unit MyFuncOne;

// Author: Vayrus
// WWW: vayrus.do.am
// ,  

interface

uses
  Windows, //  SWITCH   
  Forms, //  Application.ProcessMessages  Application.Handle ()
  Classes,
  SysUtils, //   
  StdCtrls,
  MPlayer, //  OpenCloseCD
  registry, //     , GetDirOne, Autorun
  printers, //     
  MMSystem, //  OpenCloseCD   WAV-
  ShlObj, //  GetDirTwo,     
  ShellApi, //     , ShellExecute    
  Tlhelp32, //  KillTask  KillApp
  WinINet, //  ClearIECache,  
  Dialogs, //  ShowMessage
  FileCtrl, //  UpdateDCB  OnlyReadyDrives
  Graphics, //  FDMinMaxExec
  ComCtrls, //  CopyFilePro
  IniFiles, //  AddToAutorunINI
  ComObj, //      
  Controls, //  ...
  ExtCtrls, //  SetFBB
  Messages, //  CloseApp
  ActiveX //   
  {, CommCtrl};

//   ////////////////////////////////////////
//
Type //
  PUSER_INFO_11 = ^USER_INFO_11; //

  _USER_INFO_11 = Record //
    usri11_name: LPWSTR; //
    usri11_comment: LPWSTR; //
    usri11_usr_comment: LPWSTR; //
    usri11_full_name: LPWSTR; //
    usri11_priv: DWORD; //
    usri11_auth_flags: DWORD; //
    usri11_password_age: DWORD; //
    usri11_home_dir: LPWSTR; //
    usri11_parms: LPWSTR; //
    usri11_last_logon: DWORD; //
    usri11_last_logoff: DWORD; //
    usri11_bad_pw_count: DWORD; //
    usri11_num_logons: DWORD; //
    usri11_logon_server: LPWSTR; //
    usri11_country_code: DWORD; //
    usri11_workstations: LPWSTR; //
    usri11_max_storage: DWORD; //
    usri11_units_per_week: DWORD; //
    usri11_logon_hours: Pointer; //
    usri11_code_page: DWORD; //
  End; //

  USER_INFO_11 = _USER_INFO_11; //
  //
Function NetUserGetInfo(servername: LPWSTR; username: LPWSTR; level: DWORD; //
  bufptr: Pointer): DWORD; stdcall; external 'netapi32.dll'; //
//
Function NetApiBufferFree(Buffer: Pointer): DWORD; //
  stdcall; external 'netapi32.dll'; //
//
function isAdmin: Boolean;
//                                //
//
/// //////////////////////////////////////////////////////////////////////////////
//    /////////////////////////////////////////////////
//
procedure GetOSVerInfo(var Platform, OSVer, Build: string); //
procedure GetSysInfo(var ProcVender, ProcLevel, ProcNum, BiosVer: string); //
procedure GetMemStatus(var MemUse, MemPhysTotal, MemPhysFree, //
  MemVirtTotal, MemVirtFree: string); //
procedure GetPrintInfo(var PrnName: string); //
procedure GetCPUSpeed(var CPUSpeed: string); //
//
/// //////////////////////////////////////////////////////////////////////////////
//  ////////////////////////////////////////////////////////////////

function GetDirOne(dirindex: integer): string;
//   ,   
function GetDirTwo(dirindex: integer): string;
//     
function PathFromName(Name: string): string;
//       

/// //////////////////////////////////////////////////////////////////////////////
//      ///////////////////////////////////////

// function ExtractShortPathName(const FileName: string): string;     -    
// function ExcludeTrailingPathDelimiter(const S: string): string;    -   "\"  "/"
// function ExcludeTrailingBackslash(const S: string): string;        -   "\"  "/"
// function IncludeTrailingBackslash(const S: string): string;        -  "\"   ,   
// function IncludeTrailingPathDelimiter(const S: string): string;    -  "\"   ,   
// function IsPathDelimiter(const S: string; Index: Integer): Boolean;- true,     Index  S  "\"  "/"

/// //////////////////////////////////////////////////////////////////////////////
//     ////////////////////////////////////////////////////

function DeleteSpace(s: string): string; //    
procedure DelTwoSpace(var s: string); //     
function RepairPathName(d1: String): String;
//    d1   "\"  "/"
function GetDirectory(St: string): String;
//  "\"   ,    // 
function DelEndChar(s: string): string;
//    s   // 
function GetRelativeDirectory(St: string): String;
//      
function CutExt(s: string): string; //     
function FormatPath(Path: string; NumChar: byte): string;
//    

/// //////////////////////////////////////////////////////////////////////////////

function ExecuteFile(FileName: string; Maximized: Boolean): Boolean;
//   
procedure RunAndWait(appname, commline: string);
//      

procedure SetWallpaper(sWallpaperBMPPath: String; bTile: Boolean);
//   WallPaper  Windows
function GetDT(DName: string): string; //   
function IsDriveReady(DriveLetter: char): bool; //   
procedure DesktopUpdate; //   
procedure SetFBB(F: TForm; I: TImage); //   
procedure PLAYWAV(FN: string; LOOP, STOP: Boolean); //  WAV-
function OpenCloseCD(Drive: char; open: Boolean): integer;
//      //0-   
function PrintFile(FileName: string): Boolean; //  

function FileVersion(NameApp: string): string; //   
// procedure AttrSet(FN:string;ReadOnly,Hidden,System,Archive:boolean); //   
function GetBuildTime: TDateTime; //    

procedure ShadeIt(F: TForm; c: TControl; Width: integer; Color: TColor);
//    
procedure GetDiskSizeAvail(TheDrive: PChar; var TotalBytes: double;
  var TotalFree: double); //       
procedure RunHelp(hlpFN: string); //   
procedure CreateLink(const appname, LinkLocation, LinkDesc, RunParam: string);
//  
function WinRunTime: string; //   
function WinWorkTime: string; //   
function BiteToKBite(Bite: integer): string;
//       
function AddToEndOfFile(FN, TEXT: string): Boolean;
//     
function WeekDay: string; //   
function Browse(Caption: string): string; //      
procedure ExploreFolder(Path: string; Maximized: Boolean);
//    
procedure VolumeControl; // 
procedure ShowAbout(appname, Copyright: string); //  
procedure HIDE;
//        Alt+Ctrl+Delete,   
procedure MouseKeybKill(Mouse, Keyb: Boolean);
//      
procedure THEND;
//    SHAREWARE,     
function AppIsMinimized: Boolean; //     
function OSVerIsWin95: Boolean; //  Win95? (  )
function BuilderIsRunning: Boolean; //    ?
procedure InOpenWith(FileName: string); //      
function FDMinMaxExec(FD: TFontDialog; min, max: integer): TFont;
//         

function GetStringCount(FileName: string): integer;
//     
function DeleteSpaceStrings(TS: TStrings): TStrings;
//    TStrings
function InvertStr(const s: string): string;
//     
procedure PrintStrings(Strings: TStrings);
//   TMemo  TListbox
procedure MemoSort(Memo: TMemo); //    Memo
function IntToWords(s: string): string; //    
procedure AddFiles(OD: TOpenDialog; LB: TListBox);
//     ListBox
procedure DelSel(LB: TListBox); //     ListBox
function InSSpace(s: string): string;
//      
procedure AddToAutorunINI(FileName: string; RemoveKey: Boolean);
//     INI
procedure RunOnStartup(sProgTitle, sCmdLine: string; bRunOnce: Boolean);
//     (   )
function RunWORD: Boolean; //  
procedure OnlyOneCopy(OnCreate: Boolean);
//       
//      (true)    OnClose  (false)
//    ,      
Procedure ClearIECache;
//   (cookie) IE.       . 
function GetINetFile(const INetFileName, LocalFileName: string): Boolean;
//    
function IsValidEmail(const Value: string): Boolean;
//   E-mail 
Function CheckUrl(url: string): Boolean; //    URL
function GIEF: TStrings; //   IE

procedure CloseApp(Caption: string; force: Boolean);
//     
procedure KillApp(Caption: string); //     
function KillTask(ExeFileName: string): integer;
//      
procedure SHUTDOWN(force: Boolean); //     
procedure ShutdownForce(LOGOFF: Boolean);
//    
procedure REBOOT(EmulateDos: Boolean);
//     (/  DOS)

function FullRemoveDir(Dir: string; RemoveRoot: Boolean): Boolean;
//         (    )
procedure DelAfterReboot(FileOrFolder: string);
//      
procedure MoveAfterReboot(InFileOrFolder, OutFileOrFolder: string);
//      
procedure MoveFileOrFolder(InF, OutF: string);
//      
function CopyFilePro(pb: TProgressBar; infile, outfile: string): Boolean;
//    
// , , .     TListBox
// (Action: FO_DELETE, FO_RENAME, FO_MOVE, FO_COPY)   ,  FOF_ALLOWUNDO  .
function FileOperation(FL: TListBox; ToPath: string; Action: integer;
  ToRB: Boolean): Boolean;
procedure CopyFiles(const FromFolder, ToFolder: string);
//      
function GetFS(const FileName: string): longint; //   
procedure RegisterDLL(FN: string; Reg: Boolean = true);
//  reg = true,    DLL,  - 
procedure ClearRB; //  
procedure CopyRec(const FromFolder, ToFolder: string);
//         
// -, CopyRec('c:\test','c:\test2');

procedure UpdateDCB(DCB: TDriveComboBox);
//     DriveComboBox
procedure OnlyReadyDrives(DCB: TDriveComboBox);
//       DriveComboBox

function AttachToFile(const AFileName: string; MemoryStream: TMemoryStream)
  : Boolean; //      
function LoadFromFile(const AFileName: string; MemoryStream: TMemoryStream)
  : Boolean; //

/// //////////////////////////////////////////////////////////////////////////////
implementation

/// ////////////////////////////////////////////////////////////////
/// //////////////////////////////////////////////////////////////////////////////

/// //////////////////////////////////////////////////////////////////////////////
//                                         //
/// //////////////////////////////////////////////////////////////////////////////
procedure ShutdownForce(LOGOFF: Boolean);
var
  I: integer;
begin
  if LOGOFF then
    I := EWX_LOGOFF
  else
    I := EWX_FORCE;
  ExitWindowsEx(I, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                             //
/// //////////////////////////////////////////////////////////////////////////////
procedure REBOOT(EmulateDos: Boolean);
var
  I: integer;
begin
  if EmulateDos then
    I := 1
  else
    I := 0;
  ExitWindows(EW_RESTARTWINDOWS, I);
  // EW_RESTARTWINDOWS
  // EW_REBOOTSYSTEM
  // EW_EXITANDEXECAPP
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                       //
/// //////////////////////////////////////////////////////////////////////////////
function GetDiskFreeSpaceEx(lpDirectoryName: PChar;
  var lpFreeBytesAvailableToCaller: integer; var lpTotalNumberOfBytes: integer;
  var lpTotalNumberOfFreeBytes: integer): bool; stdcall;
  external kernel32 name 'GetDiskFreeSpaceExW';

procedure GetDiskSizeAvail(TheDrive: PChar; var TotalBytes: double;
  var TotalFree: double);
var
  AvailToCall: integer;
  TheSize: integer;
  FreeAvail: integer;
begin
  GetDiskFreeSpaceEx(TheDrive, AvailToCall, TheSize, FreeAvail);
{$IFOPT Q+}
{$DEFINE TURNOVERFLOWON}
{$Q-}
{$ENDIF}
  if TheSize >= 0 then
    TotalBytes := TheSize
  else if TheSize = -1 then
  begin
    TotalBytes := $7FFFFFFF;
    TotalBytes := TotalBytes * 2;
    TotalBytes := TotalBytes + 1;
  end
  else
  begin
    TotalBytes := $7FFFFFFF;
    TotalBytes := TotalBytes + abs($7FFFFFFF - TheSize);
  end;
  if AvailToCall >= 0 then
    TotalFree := AvailToCall
  else if AvailToCall = -1 then
  begin
    TotalFree := $7FFFFFFF;
    TotalFree := TotalFree * 2;
    TotalFree := TotalFree + 1;
  end
  else
  begin
    TotalFree := $7FFFFFFF;
    TotalFree := TotalFree + abs($7FFFFFFF - AvailToCall);
  end;
end;
{ -,
  procedure TForm1.Button1Click(Sender: TObject);
  var
  TotalBytes : double;
  TotalFree : double;
  begin
  GetDiskSizeAvail('C:\',TotalBytes,TotalFree);
  ShowMessage(FloatToStr(TotalBytes));
  ShowMessage(FloatToStr(TotalFree));
  end;
}

/// //////////////////////////////////////////////////////////////////////////////
//                                                       //
/// //////////////////////////////////////////////////////////////////////////////
function IsDriveReady(DriveLetter: char): bool;
var
  OldErrorMode: Word;
  OldDirectory: string;
begin
  OldErrorMode := SetErrorMode(SEM_NOOPENFILEERRORBOX);
  GetDir(0, OldDirectory);
{$I-}
  ChDir(DriveLetter + ':\');
{$I+}
  if IoResult <> 0 then
    Result := False
  else
    Result := true;
  ChDir(OldDirectory);
  SetErrorMode(OldErrorMode);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                          //
/// //////////////////////////////////////////////////////////////////////////////
function BiteToKBite(Bite: integer): string;
begin
  Result := IntToStr(Bite div 1024) + ' ';
end;

/// //////////////////////////////////////////////////////////////////////////////
//                               //
/// //////////////////////////////////////////////////////////////////////////////
function InSSpace(s: string): string;
const
  ch: string[6] = '.,:;!?';
var
  k, l: integer;
begin
  k := 1;
  repeat
    for l := 1 to 6 do
      if (AnsiChar(s[k]) = ch[l]) and (AnsiChar(s[k + 1]) <> ch[l]) then
        insert(' ', s, k + 1);
    k := k + 1;
  until k = length(s);
  Result := s;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                //
/// //////////////////////////////////////////////////////////////////////////////
var
  Dummy: integer = 0;
  OldKbHook: HHook = 0;

function KbHook(code: integer; wparam: Word; lparam: longint): longint; stdcall;
begin
  if code < 0 then
    Result := CallNextHookEx(OldKbHook, code, wparam, lparam)
  else
    Result := 1;
end;

procedure MouseKeybKill(Mouse, Keyb: Boolean);
begin
  if Keyb then
  begin
    SystemParametersInfo(SPI_SETFASTTASKSWITCH, 1, @Dummy, 0);
    SystemParametersInfo(SPI_SCREENSAVERRUNNING, 1, @Dummy, 0);
    OldKbHook := SetWindowsHookEx(WH_KEYBOARD, @KbHook, HInstance, 0);
  end
  else
  begin
    if OldKbHook <> 0 then
    begin
      UnHookWindowshookEx(OldKbHook);
      OldKbHook := 0;
    end;
    SystemParametersInfo(SPI_SETFASTTASKSWITCH, 0, 0, 0);
    SystemParametersInfo(SPI_SCREENSAVERRUNNING, 0, 0, 0);
  end;
  if Mouse then
  begin
    SystemParametersInfo(SPI_SETFASTTASKSWITCH, 1, @Dummy, 0);
    SystemParametersInfo(SPI_SCREENSAVERRUNNING, 1, @Dummy, 0);
    OldKbHook := SetWindowsHookEx(WH_MOUSE, @KbHook, HInstance, 0);
  end
  else
  begin
    if OldKbHook <> 0 then
    begin
      UnHookWindowshookEx(OldKbHook);
      OldKbHook := 0;
    end;
    SystemParametersInfo(SPI_SETFASTTASKSWITCH, 0, 0, 0);
    SystemParametersInfo(SPI_SCREENSAVERRUNNING, 0, 0, 0);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                                //
/// //////////////////////////////////////////////////////////////////////////////
function SHEmptyRecycleBinA(HWND: HWND; pszRootPath: PChar; dwFlags: DWORD)
  : HRESULT; stdcall; external 'shell32.dll';

procedure ClearRB;
begin
  SHEmptyRecycleBinA(0, nil, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                //
/// //////////////////////////////////////////////////////////////////////////////

/// //////////////////////////////////////////////////////////////////////////////
//                                            //
/// //////////////////////////////////////////////////////////////////////////////

/// //////////////////////////////////////////////////////////////////////////////
//                                                          //
/// //////////////////////////////////////////////////////////////////////////////
function GetDT(DName: string): string;
begin
  case GetDriveType(PChar(DName)) of
    0:
      Result := '     ';
    1:
      Result := '   ';
    DRIVE_REMOVABLE:
      Result := 'FLOPPY';
    DRIVE_FIXED:
      Result := 'HARD';
    DRIVE_REMOTE:
      Result := 'REMOTE';
    DRIVE_CDROM:
      Result := 'CD-ROM';
    DRIVE_RAMDISK:
      Result := 'RAM';
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                       //
/// //////////////////////////////////////////////////////////////////////////////
procedure DesktopUpdate;
begin
  SendMessage(FindWindow('Progman', 'Program Manager'), WM_COMMAND, $A065, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                               //
/// //////////////////////////////////////////////////////////////////////////////
procedure CreateLink(const appname, LinkLocation, LinkDesc, RunParam: string);
var
  IObject: IUnknown;
  SLink: IShellLink;
  PFile: IPersistFile;
begin
  IObject := CreateComObject(CLSID_ShellLink);
  SLink := IObject as IShellLink;
  PFile := IObject as IPersistFile;
  with SLink do
  begin
    SetArguments(PChar(RunParam));
    SetDescription(PChar(LinkDesc));
    SetPath(PChar(appname));
    SetWorkingDirectory
      (PChar(ExcludeTrailingBackslash(ExtractFilePath(appname))));
  end;
  PFile.Save(PWChar(WideString(LinkLocation)), False);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                      //
/// //////////////////////////////////////////////////////////////////////////////
function WinRunTime: string;
const
  MS = 1000;
  HOURSPERDAY = 24;
  MINPERHOUR = 60;
  SECPERMIN = 60;
  SECPERHOUR = MINPERHOUR * SECPERMIN;
  SECPERDAY = HOURSPERDAY * SECPERHOUR;
begin
  Result := DateTimeToStr(Now - GetTickCount / (SECPERDAY * MS));
end;

function WinWorkTime: string;
const
  MS = 1000;
  HOURSPERDAY = 24;
  MINPERHOUR = 60;
  SECPERMIN = 60;
  SECPERHOUR = MINPERHOUR * SECPERMIN;
  SECPERDAY = HOURSPERDAY * SECPERHOUR;
var
  Uptime: Cardinal;
  TmpStr: string;
begin
  Uptime := GetTickCount div MS;
  // DAYS
  TmpStr := IntToStr(Uptime div SECPERDAY) + '  ';
  Uptime := Uptime mod SECPERDAY;
  // HOURS
  TmpStr := TmpStr + IntToStr(Uptime div SECPERHOUR) + '  ';
  Uptime := Uptime mod SECPERHOUR;
  // MINUTES
  TmpStr := TmpStr + IntToStr(Uptime div SECPERMIN) + '  ';
  Uptime := Uptime mod SECPERMIN;
  // SECONDS
  TmpStr := TmpStr + IntToStr(Uptime) + ' ';
  // RESULY
  Result := TmpStr;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                         //
/// //////////////////////////////////////////////////////////////////////////////
procedure SHUTDOWN(force: Boolean);
var
  w: integer;
begin
  if force then
    w := wm_quit
  else
    w := wm_close;
  SendMessage(FindWindow('Progman', 'Program Manager'), w, 0, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                   //
/// //////////////////////////////////////////////////////////////////////////////
function AddToEndOfFile(FN, TEXT: string): Boolean;
var
  F: TextFile;
begin
  Result := true;
  try
    AssignFile(F, FN);
    Append(F);
    Writeln(F, TEXT);
    Flush(F);
    CloseFile(F);
  except
    Result := False;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                     //
/// //////////////////////////////////////////////////////////////////////////////
procedure CloseApp(Caption: string; force: Boolean);
var
  w: integer;
begin
  if force then
    w := wm_quit
  else
    w := wm_close;
  postmessage(FindWindow(PChar(Caption), nil), w, 0, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                        //
/// //////////////////////////////////////////////////////////////////////////////
procedure SetFBB(F: TForm; I: TImage);
begin
  F.brush.bitmap := I.picture.bitmap;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                       //
/// //////////////////////////////////////////////////////////////////////////////
procedure RunHelp(hlpFN: string);
begin
  Application.HelpFile := hlpFN;
  Application.HelpCommand(HELP_FINDER, 0);
end;

/// //////////////////////////////////////////////////////////////////////////////
//    ?                                                //
/// //////////////////////////////////////////////////////////////////////////////
function BuilderIsRunning: Boolean;
begin
  if FindWindow('TAppBuilder', Nil) <> 0 Then
    Result := true
  else
    Result := False;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                         //
/// //////////////////////////////////////////////////////////////////////////////
procedure ShadeIt(F: TForm; c: TControl; Width: integer; Color: TColor);
var
  rect: TRect;
  old: TColor;
begin
  if (c.Visible) then
  begin
    rect := c.BoundsRect;
    rect.Left := rect.Left + Width;
    rect.Top := rect.Top + Width;
    rect.Right := rect.Right + Width;
    rect.Bottom := rect.Bottom + Width;
    old := F.Canvas.brush.Color;
    F.Canvas.brush.Color := Color;
    F.Canvas.fillrect(rect);
    F.Canvas.brush.Color := old;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                 //
/// //////////////////////////////////////////////////////////////////////////////
procedure CopyRec(const FromFolder, ToFolder: string);
var
  OpStruc: TSHFileOpStruct;
  frombuf, tobuf: Array [0 .. 128] of char;
begin
  FillChar(frombuf, Sizeof(frombuf), 0);
  FillChar(tobuf, Sizeof(tobuf), 0);
  StrPCopy(frombuf, FromFolder + '\*.*');
  StrPCopy(tobuf, ToFolder);
  With OpStruc DO
  Begin
    Wnd := Application.Handle;
    wFunc := FO_COPY;
    pFrom := @frombuf;
    pTo := @tobuf;
    fFlags := FOF_NOCONFIRMATION or FOF_RENAMEONCOLLISION;
    fAnyOperationsAborted := False;
    hNameMappings := Nil;
    lpszProgressTitle := Nil;
  end;
  ShFileOperation(OpStruc);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                           //
/// //////////////////////////////////////////////////////////////////////////////
procedure CopyFiles(const FromFolder, ToFolder: string);
var
  Fo: TSHFileOpStruct;
  Buffer: array [0 .. 4096] of char;
  p: PChar;
begin
  FillChar(Buffer, Sizeof(Buffer), #0);
  p := @Buffer;
  StrECopy(p, PChar(FromFolder)); // ,    
  FillChar(Fo, Sizeof(Fo), #0);
  Fo.Wnd := Application.Handle;
  Fo.wFunc := FO_COPY;
  Fo.pFrom := @Buffer;
  Fo.pTo := PChar(ToFolder); //    
  Fo.fFlags := 0;
  if ((ShFileOperation(Fo) <> 0) or (Fo.fAnyOperationsAborted <> False)) then
    ShowMessage(' .')
end;

/// //////////////////////////////////////////////////////////////////////////////
//  WAV-                                                       //
/// //////////////////////////////////////////////////////////////////////////////
procedure PLAYWAV(FN: string; LOOP, STOP: Boolean);
begin
  if STOP then
    sndPlaySound(Nil, SND_ASYNC)
  else
  begin
    if LOOP then
      sndPlaySound(PChar(FN), SND_ASYNC + SND_LOOP)
    else
      sndPlaySound(PChar(FN), SND_ASYNC);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                          //
/// //////////////////////////////////////////////////////////////////////////////
function WeekDay: string;
begin
  case DayOfWeek(date) of
    2:
      Result := '';
    3:
      Result := '';
    4:
      Result := '';
    5:
      Result := '';
    6:
      Result := '';
    7:
      Result := '';
  else
    Result := '';
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                       //
/// //////////////////////////////////////////////////////////////////////////////
function GetFS(const FileName: string): longint;
var
  SearchRec: TSearchRec;
begin
  if FindFirst(ExpandFileName(FileName), faAnyFile, SearchRec) = 0 then
    Result := SearchRec.Size
  else
    Result := -1;
  FindClose(SearchRec);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                                 //
/// //////////////////////////////////////////////////////////////////////////////
function RunWORD: Boolean;
var
  MsWord: Variant;
begin
  try
    MsWord := CreateOleObject('Word.Application');
    //     OLE 
    MsWord.Visible := true;
    MsWord.Documents.Add; //   
    // MsWord.Selection.Font.Bold := True; //   
    // MsWord.Selection.Font.Size := 12; //  12 
    // MsWord.Selection.TypeText('');
    Result := true;
  except
    Result := False;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                               //
/// //////////////////////////////////////////////////////////////////////////////
procedure InOpenWith(FileName: string);
begin
  ShellExecute(0, 'open', 'rundll32.exe',
    PChar(Format('shell32.dll,OpenAs_RunDLL %s', [FileName])), nil, SW_SHOW);
end;

/// //////////////////////////////////////////////////////////////////////////////
function GetIEFavourites(const favpath: string): TStrings; //
var
  SearchRec: TSearchRec;
  str: TStrings;
  Path, Dir, FileName: String;
  Buffer: array [0 .. 2047] of char;
  found: integer;
begin
  str := TStringList.Create;
  // Get all file names in the favourites path
  Path := favpath + '\*.url';
  Dir := ExtractFilePath(Path);
  found := FindFirst(Path, faAnyFile, SearchRec);
  while found = 0 do
  begin
    // Get now URLs from files in variable files
    SetString(FileName, Buffer, GetPrivateProfileString('InternetShortcut',
      PChar('URL'), NIL, Buffer, Sizeof(Buffer), PChar(Dir + SearchRec.Name)));
    str.Add(FileName);
    found := FindNext(SearchRec);
    Application.ProcessMessages;
  end;
  // unterordner finden
  found := FindFirst(Dir + '\*.*', faAnyFile, SearchRec);
  while found = 0 do
  begin
    if ((SearchRec.Attr and faDirectory) > 0) and (SearchRec.Name[1] <> '.')
    then
      str.AddStrings(GetIEFavourites(Dir + '\' + SearchRec.Name));
    found := FindNext(SearchRec);
    Application.ProcessMessages;
  end;
  FindClose(SearchRec);
  Result := str;
end;

/// //////////////////////////////////////////////////////////////////////////////
//   IE                                                        //
/// //////////////////////////////////////////////////////////////////////////////
function GIEF: TStrings;
var
  pidl: PItemIDList;
  favpath: array [0 .. MAX_PATH] of char;
begin
  SHGetSpecialFolderLocation(Application.Handle, CSIDL_FAVORITES, pidl);
  SHGetPathFromIDList(pidl, favpath);
  Result := GetIEFavourites(StrPas(favpath));
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                        //
/// //////////////////////////////////////////////////////////////////////////////
function PathFromName(Name: string): string;
var
  buf: array [0 .. MAX_PATH] of char;
  filepart: PChar;
begin
  if SearchPath(nil, PChar(Name), nil, Sizeof(buf), buf, filepart) > 0 then
    Result := buf
  else
  begin
    if ExtractFileExt(Name) = '' then
    begin
      if SearchPath(nil, PChar(ChangeFileExt(Name, '.exe')), nil, Sizeof(buf),
        buf, filepart) > 0 then
        Result := buf;
    end;
  end;
end;
// :
// system      -> C:\WINDOWS\system
// Temp        -> C:\WINDOWS\Temp
// notepad.exe -> C:\WINDOWS\notepad.exe
// notepad     -> C:\WINDOWS\notepad.exe
// project1    -> D:\PROGRAM\DELPHI5\PROJECTS\project1.exe

/// //////////////////////////////////////////////////////////////////////////////
function ShortNum(num: Word; razr: integer): string; //
const
  hundreds: array [0 .. 9] of string = ('', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ',
    ' ');
  tens: array [0 .. 9] of string = ('', '', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ');
  ones: array [3 .. 19] of string = (' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ',
    ' ', ' ', ' ');
  razryad: array [0 .. 6] of string = ('', ' ', ' ', ' ',
    ' ', ' ', ' ');
var
  t: byte; // 
  o: byte; // 
begin
  Result := hundreds[num div 100];
  if num mod 100 = 0 then
    Exit;
  t := (num mod 100) div 10;
  o := num mod 10;
  if t <> 1 then
  begin
    Result := Result + tens[t];
    case o of
      1:
        if razr = 1 then
          Result := Result + ' '
        else
          Result := Result + ' ';
      2:
        if razr = 1 then
          Result := Result + ' '
        else
          Result := Result + ' ';
      3 .. 9:
        Result := Result + ones[o];
    end;
    Result := Result + razryad[razr];
    case o of
      1:
        if razr = 1 then
          Result := Result + '';
      2 .. 4:
        if razr = 1 then
          Result := Result + ''
        else if razr > 1 then
          Result := Result + '';
    else
      if razr > 1 then
        Result := Result + '';
    end;
  end
  else
  begin
    Result := Result + ones[num mod 100];
    Result := Result + razryad[razr];
    if razr > 1 then
      Result := Result + '';
  end;
end;

//
/// //////////////////////////////////////////////////////////////////////////////
//                                                     //
/// //////////////////////////////////////////////////////////////////////////////
function IntToWords(s: string): string;
var
  I, count: integer;
begin
  if length(s) <= 0 then
  begin
    Result := ' ';
    Exit;
  end;
  count := (length(s) + 2) div 3;
  if count > 7 then
  begin
    Result := '  ';
    Exit;
  end;
  Result := '';
  s := '00' + s;
  for I := 1 to count do
    Result := ShortNum(StrToInt(copy(s, length(s) - 3 * I + 1, 3)),
      I - 1) + Result;
  if length(Result) > 0 then
    delete(Result, 1, 1);
end;

/// //////////////////////////////////////////////////////////////////////////////
//    MEMO                                                      //
/// //////////////////////////////////////////////////////////////////////////////
procedure MemoSort(Memo: TMemo);
var
  t: TStringList;
begin
  t := TStringList.Create; // 
  t.AddStrings(Memo.lines); //   t   Memo
  t.Sort; // 
  Memo.Clear;
  Memo.lines.AddStrings(t); //  memo   
  t.Free;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                 //
/// //////////////////////////////////////////////////////////////////////////////
procedure AddToAutorunINI(FileName: string; RemoveKey: Boolean);
var
  I: TIniFile;
  short: string;
begin
  short := ExtractShortPathName(FileName);
  I := TIniFile.Create('WIN.INI');
  if RemoveKey then
    I.DeleteKey('windows', 'run')
  else
    I.WriteString('windows', 'run', short);
  I.Free;
end;

procedure RunOnStartup(sProgTitle, sCmdLine: string; bRunOnce: Boolean);
var
  sKey: string;
  Reg: TRegIniFile;
begin
  if bRunOnce then
    sKey := 'Once'
  else
    sKey := '';
  Reg := TRegIniFile.Create('');
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  Reg.WriteString('Software\Microsoft\Windows\CurrentVersion\Run' + sKey + #0,
    sProgTitle, sCmdLine);
  Reg.Free;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                      //
/// //////////////////////////////////////////////////////////////////////////////
function DeleteSpace(s: string): string;
begin
  while pos(' ', s) <> 0 do
    delete(s, (pos(' ', s)), 1);
  Result := s;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                             //
/// //////////////////////////////////////////////////////////////////////////////
function InvertStr(const s: string): string;
var
  rs: string;
  I: integer;
begin
  for I := 1 to length(s) do
    rs := Concat(s[I], rs);
  Result := rs;
end;

/// //////////////////////////////////////////////////////////////////////////////
//    TStrings                                                  //
/// //////////////////////////////////////////////////////////////////////////////
function DeleteSpaceStrings(TS: TStrings): TStrings;
var
  I: integer;
  s: string;
begin
  for I := 0 to TS.count - 1 do
  begin
    s := TS.Strings[I];
    TS.Strings[I] := DeleteSpace(s);
  end;
  Result := TS;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                                  //
/// //////////////////////////////////////////////////////////////////////////////
function GetStringCount(FileName: string): integer;
var
  F: TextFile;
  s: String;
begin
  Result := 0;
  try
    AssignFile(F, FileName);
    Reset(F);
    while NOT EOF(F) do
    begin
      ReadLn(F, s);
      inc(Result)
    end;
    CloseFile(F);
  except
    Exit;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                          //
/// //////////////////////////////////////////////////////////////////////////////
function GetINetFile(const INetFileName, LocalFileName: string): Boolean;
const
  BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array [1 .. BufferSize] of byte;
  BufferLen: DWORD;
  F: File;
begin
  Result := true;
  try
    hSession := InternetOpen(PChar(ExtractFileName(ParamStr(0))),
      INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
    hURL := InternetOpenURL(hSession, PChar(INetFileName), nil, 0, 0, 0);
    AssignFile(F, LocalFileName);
    Rewrite(F, 1);
    repeat
      InternetReadFile(hURL, @Buffer, Sizeof(Buffer), BufferLen);
      BlockWrite(F, Buffer, BufferLen);
      Application.ProcessMessages;
    until BufferLen = 0;
    CloseFile(F);
    InternetCloseHandle(hURL);
    InternetCloseHandle(hSession);
  except
    Result := False;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//   E-mail                                           //
/// //////////////////////////////////////////////////////////////////////////////
function IsValidEmail(const Value: string): Boolean;
  function CheckAllowed(const s: string): Boolean;
  var
    I: integer;
  begin
    Result := False;
    for I := 1 to length(s) do
    begin
      {    s -    }
      if not(s[I] in ['a' .. 'z', 'A' .. 'Z', '0' .. '9', '_', '-', '.']) then
        Exit;
    end;
    Result := true;
  end;

var
  I: integer;
  namePart, serverPart: string;
begin //   IsValidEmail
  Result := False;
  I := pos('@', Value);
  if I = 0 then
    Exit;
  namePart := copy(Value, 1, I - 1);
  serverPart := copy(Value, I + 1, length(Value));
  // @        ;   . " a.com"
  if (length(namePart) = 0) or ((length(serverPart) < 5)) then
    Exit;
  I := pos('.', serverPart);
  //          
  if (I = 0) or (I > (length(serverPart) - 2)) then
    Exit;
  Result := CheckAllowed(namePart) and CheckAllowed(serverPart);
end;

/// //////////////////////////////////////////////////////////////////////////////
//    URL                                              //
/// //////////////////////////////////////////////////////////////////////////////
Function CheckUrl(url: string): Boolean;
var
  hSession, hfile: HInternet;
  dwindex, dwcodelen: DWORD;
  dwcode: array [1 .. 20] of char;
  res: PChar;
begin
  if pos('http://', lowercase(url)) = 0 then
    url := 'http://' + url;
  Result := False;
  hSession := InternetOpen('InetURL:/1.0', INTERNET_OPEN_TYPE_PRECONFIG,
    nil, nil, 0);
  if assigned(hSession) then
  begin
    hfile := InternetOpenURL(hSession, PChar(url), nil, 0,
      INTERNET_FLAG_RELOAD, 0);
    dwindex := 0;
    dwcodelen := 10;
    HttpQueryInfo(hfile, HTTP_QUERY_STATUS_CODE, @dwcode, dwcodelen, dwindex);
    res := PChar(@dwcode);
    Result := (res = '200') or (res = '302');
    if assigned(hfile) then
      InternetCloseHandle(hfile);
    InternetCloseHandle(hSession);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//     Strings                                          //
/// //////////////////////////////////////////////////////////////////////////////
procedure AddFiles(OD: TOpenDialog; LB: TListBox);
var
  I: integer;
begin
  OD.Options := [ofAllowMultiSelect, ofPathMustExist, ofFileMustExist,
    ofEnableSizing];
  if OD.Execute then
    for I := 0 to OD.Files.count - 1 do
      LB.Items.Add(OD.Files[I]);
end;

/// //////////////////////////////////////////////////////////////////////////////
//     ListBox                                          //
/// //////////////////////////////////////////////////////////////////////////////
procedure DelSel(LB: TListBox);
var
  I: integer;
begin
  if LB.count > 0 then
  begin
    I := 0;
    while I < LB.count do
    begin
      if LB.Selected[I] then
      begin
        LB.Items.delete(I);
        Application.ProcessMessages;
      end
      else
        inc(I);
    end;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//   TMemo  TListbox                                        //
/// //////////////////////////////////////////////////////////////////////////////
procedure PrintStrings(Strings: TStrings);
var
  Prn: TextFile;
  I: Word;
begin
  AssignPrn(Prn);
  try
    Rewrite(Prn);
    try
      for I := 0 to Strings.count - 1 do
        Writeln(Prn, Strings.Strings[I]);
    finally
      CloseFile(Prn);
    end;
  except
    on EInOutError do
      MessageDlg('  .', mtError, [mbOk], 0);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//       ,  d -        //
/// //////////////////////////////////////////////////////////////////////////////
function DeleteSym(d, s: string): string;
begin
  while pos(d, s) <> 0 do
    delete(s, (pos(d, s)), 1);
  Result := s;
end;

/// //////////////////////////////////////////////////////////////////////////////
// , , .     TListBox              //
// (FO_DELETE, FO_RENAME, FO_MOVE, FO_COPY)   ,  FOF_ALLOWUNDO  .
/// //////////////////////////////////////////////////////////////////////////////
function FileOperation(FL: TListBox; ToPath: string; Action: integer;
  ToRB: Boolean): Boolean;
var
  SHFO: TSHFileOpStruct;
  I: integer;
  FromPath: string;
begin
  with SHFO do
  begin
    Wnd := Application.Handle;
    wFunc := Action;
    FromPath := '';
    for I := 0 to FL.Items.count - 1 do
      FromPath := FromPath + FL.Items.Strings[I] + #0;
    FromPath := FromPath + #0;
    pFrom := PChar(FromPath);
    pTo := PChar(ToPath);
    fFlags := 0;
    if ToRB then
      fFlags := FOF_ALLOWUNDO;
  end;
  Result := ShFileOperation(SHFO) = 0;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                           //
/// //////////////////////////////////////////////////////////////////////////////
function FileVersion(NameApp: string): string;
var
  dump: DWORD;
  Size: integer;
  Buffer: PChar;
  VersionPointer, TransBuffer: PChar;
  Temp: integer;
  CalcLangCharSet: string;
begin
  Size := GetFileVersionInfoSize(PChar(NameApp), dump);
  Buffer := StrAlloc(Size + 1);
  try
    GetFileVersionInfo(PChar(NameApp), 0, Size, Buffer);
    VerQueryValue(Buffer, '\VarFileInfo\Translation',
      Pointer(TransBuffer), dump);
    if dump >= 4 then
    begin
      Temp := 0;
      StrLCopy(@Temp, TransBuffer, 2);
      CalcLangCharSet := IntToHex(Temp, 4);
      StrLCopy(@Temp, TransBuffer + 2, 2);
      CalcLangCharSet := CalcLangCharSet + IntToHex(Temp, 4);
    end;
    VerQueryValue(Buffer, PChar('\StringFileInfo\' + CalcLangCharSet + '\' +
      'FileVersion'), Pointer(VersionPointer), dump);
    if (dump > 1) then
    begin
      SetLength(Result, dump);
      StrLCopy(PChar(Result), VersionPointer, dump);
    end
    else
      Result := '0.0.0.0';
  finally
    StrDispose(Buffer);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                        //
/// //////////////////////////////////////////////////////////////////////////////
procedure DelAfterReboot(FileOrFolder: string);
begin
  MoveFileEx(PChar(FileOrFolder), nil, MOVEFILE_DELAY_UNTIL_REBOOT);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                     //
/// //////////////////////////////////////////////////////////////////////////////
procedure MoveAfterReboot(InFileOrFolder, OutFileOrFolder: string);
begin
  MoveFileEx(PChar(InFileOrFolder), PChar(OutFileOrFolder),
    MOVEFILE_DELAY_UNTIL_REBOOT);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                          //
/// //////////////////////////////////////////////////////////////////////////////
procedure MoveFileOrFolder(InF, OutF: string);
begin
  MoveFileEx(PChar(InF), PChar(OutF), MOVEFILE_REPLACE_EXISTING);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                               //
/// //////////////////////////////////////////////////////////////////////////////
procedure SWITCH(rus: Boolean);
begin
  if rus then
    LoadKeyboardLayout('00000419', KLF_ACTIVATE)
  else
    LoadKeyboardLayout('00000409', KLF_ACTIVATE);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                            //
/// //////////////////////////////////////////////////////////////////////////////
function AppIsMinimized: Boolean;
begin
  Result := IsIconic(Application.Handle);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                         //
// -////////////////////////////////////////////////////////////////////////////                                                          //
{ procedure TForm1.BitBtn1Click(Sender: TObject);
  var   aStream :TMemoryStream ;
  begin
  if opendialog1.Execute then
  begin
  aStream := TMemoryStream.Create;
  Memo1.Lines.SaveToStream(aStream);
  AttachToFile(opendialog1.FileName, aStream);
  aStream.Free;
  end;
  end;

  procedure TForm1.BitBtn2Click(Sender: TObject);
  var   aStream :TMemoryStream ;
  begin
  if opendialog1.Execute then
  begin
  aStream := TMemoryStream.Create;
  LoadFromFile(opendialog1.FileName, aStream);
  Memo1.Lines.LoadFromStream(aStream);
  aStream.Free;
  end;
  end; }

var
  aStream: TFileStream;
  iSize: integer;

function AttachToFile(const AFileName: string;
  MemoryStream: TMemoryStream): Boolean;
begin
  Result := False;
  if not FileExists(AFileName) then
    Exit;
  try
    aStream := TFileStream.Create(AFileName, fmOpenWrite or fmShareDenyWrite);
    MemoryStream.Seek(0, soFromBeginning);
    aStream.Seek(0, soFromEnd); //     
    aStream.CopyFrom(MemoryStream, 0); //     
    iSize := MemoryStream.Size + Sizeof(integer); //   
    aStream.Write(iSize, Sizeof(iSize));
  finally
    aStream.Free;
  end;
  Result := true;
end;

function LoadFromFile(const AFileName: string;
  MemoryStream: TMemoryStream): Boolean;
begin
  Result := False;
  if not FileExists(AFileName) then
    Exit;
  try
    aStream := TFileStream.Create(AFileName, fmOpenRead or fmShareDenyWrite);
    aStream.Seek(-Sizeof(integer), soFromEnd);
    //       
    aStream.Read(iSize, Sizeof(iSize));
    if iSize > aStream.Size then
    begin
      aStream.Free;
      Exit;
    end;
    aStream.Seek(-iSize, soFromEnd);
    //      
    MemoryStream.SetSize(iSize - Sizeof(integer));
    MemoryStream.CopyFrom(aStream, iSize - Sizeof(iSize));
    MemoryStream.Seek(0, soFromBeginning);
  finally
    aStream.Free;
  end;
  Result := true;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                               //
/// //////////////////////////////////////////////////////////////////////////////
function CopyFilePro(pb: TProgressBar; infile, outfile: string): Boolean; //
var
  FromF, ToF: file;
  NumRead, NumWritten: integer;
  buf: array [1 .. 2048] of char;
  Dir: string;
begin
  if infile = outfile then //
  begin //
    ShowMessage('     !' +
      #13'     .');
    Result := False; //
    Exit; //
  end; //
  if not FileExists(infile) then //
  begin //
    ShowMessage(' ' + infile + '  !'); //
    Result := False; //
    Exit; //
  end; //
  Dir := ExtractFilePath(outfile); //
  if not DirectoryExists(Dir) then //
    if not Forcedirectories(Dir) then //
    begin //
      raise Exception.Create('    ' + Dir); //
      Result := False; //
      Exit; //
    end; //
  try //
    AssignFile(FromF, infile);
    Reset(FromF, 1);
    AssignFile(ToF, outfile);
    Rewrite(ToF, 1);
    pb.max := FileSize(FromF); //
    repeat
      BlockRead(FromF, buf, Sizeof(buf), NumRead);
      BlockWrite(ToF, buf, NumRead, NumWritten);
      pb.Position := FileSize(ToF); //
      Application.ProcessMessages; //
    until (NumRead = 0) or (NumWritten <> NumRead);
    CloseFile(FromF);
    CloseFile(ToF);
    Result := true; //
  except //
    // showmessage(' !'#13' :  '
    // +extractfiledrive(outfile)+'     .');
    Result := False; //
  end; //
end;

/// //////////////////////////////////////////////////////////////////////////////
//                      //
/// //////////////////////////////////////////////////////////////////////////////
function FDMinMaxExec(FD: TFontDialog; min, max: integer): TFont;
begin
  with FD do
  begin
    Options := [fdLimitSize];
    MinFontSize := min;
    MaxFontSize := max;
    Execute;
  end;
  Result := FD.Font;
end;

/// //////////////////////////////////////////////////////////////////////////////
//       DriveComboBox                 //
// ,          plug-&-play  
/// //////////////////////////////////////////////////////////////////////////////
procedure OnlyReadyDrives(DCB: TDriveComboBox);
var
  I: integer;
  OldErrorMode: Word;
  OldDirectory: string;
begin
  OldErrorMode := SetErrorMode(SEM_NOOPENFILEERRORBOX);
  GetDir(0, OldDirectory);
  I := 0;
  while I <= DCB.Items.count - 1 do
  begin
{$I-}
    ChDir(DCB.Items[I][1] + ':\');
{$I+}
    if IoResult <> 0 then
      DCB.Items.delete(I)
    else
      inc(I);
  end;
  ChDir(OldDirectory);
  SetErrorMode(OldErrorMode);
end;

/// //////////////////////////////////////////////////////////////////////////////
//     DriveComboBox                             //
/// //////////////////////////////////////////////////////////////////////////////
type
  TNewDriveComboBox = class(TDriveComboBox)
  end;

procedure UpdateDCB(DCB: TDriveComboBox);
var
  Drive: char;
begin
  Drive := DCB.Drive;
  TNewDriveComboBox(DCB).BuildList;
  //     
  DCB.Drive := Drive;
end;

/// //////////////////////////////////////////////////////////////////////////////
//    SHAREWARE                                              //
/// //////////////////////////////////////////////////////////////////////////////
procedure THEND;
const
  TXT = 'ABCDEFGHJIKLMNOPQRSTUXZ';
begin
  if GlobalFindAtom(TXT) = 0 then
    GlobalAddAtom(TXT)
  else
  begin
    ShowMessage('      ' +
      #13'   .' +
      #13'     Windows, ,' +
      #13' , .');
    Application.Terminate;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//         (    )
/// //////////////////////////////////////////////////////////////////////////////
function FullRemoveDir(Dir: string; RemoveRoot: Boolean): Boolean;
var
  I: integer;
  SRec: TSearchRec;
  FN: String;
begin
  Result := False;
  if Dir = '' then
    Exit;
  if not DirectoryExists(Dir) then
    Exit;
  Result := true;
  Dir := IncludeTrailingBackslash(Dir) + '*.*';
  I := FindFirst(Dir, faAnyFile, SRec);
  while I = 0 do
  begin
    FN := ExtractFileDir(Dir) + '\' + SRec.Name;
    if SRec.Attr = faDirectory then
    begin
      if (SRec.Name <> '') and (SRec.Name <> '.') and (SRec.Name <> '..') then
        FullRemoveDir(FN, true);
    end
    else
    begin
      if SRec.Attr <> faArchive then
        FileSetAttr(FN, faArchive);
      if not DeleteFile(FN) then
        Result := False;
    end;
    I := FindNext(SRec);
  end;
  FindClose(SRec);
  if RemoveRoot then
    try
      if not RemoveDir(ExtractFileDir(Dir)) then
        Result := False;
    except
      Result := False;
    end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//   (cookie) IE                                                     //
/// //////////////////////////////////////////////////////////////////////////////
Procedure ClearIECache;
Var
  lpEntryInfo: PInternetCacheEntryInfo;
  hCacheDir: LongWord;
  dwEntrySize: LongWord;
  dwLastError: LongWord;
Begin
  dwEntrySize := 0;
  FindFirstUrlCacheEntry(NIL, TInternetCacheEntryInfo(NIL^), dwEntrySize);
  GetMem(lpEntryInfo, dwEntrySize);
  hCacheDir := FindFirstUrlCacheEntry(NIL, lpEntryInfo^, dwEntrySize);
  If (hCacheDir <> 0) Then
    DeleteUrlCacheEntry(lpEntryInfo^.lpszSourceUrlName);
  FreeMem(lpEntryInfo);
  Repeat
    dwEntrySize := 0;
    FindNextUrlCacheEntry(hCacheDir, TInternetCacheEntryInfo(NIL^),
      dwEntrySize);
    dwLastError := GetLastError();
    If (GetLastError = ERROR_INSUFFICIENT_BUFFER) Then
    Begin
      GetMem(lpEntryInfo, dwEntrySize);
      If (FindNextUrlCacheEntry(hCacheDir, lpEntryInfo^, dwEntrySize)) Then
        DeleteUrlCacheEntry(lpEntryInfo^.lpszSourceUrlName);
      FreeMem(lpEntryInfo);
      Application.ProcessMessages;
    End;
    Application.ProcessMessages;
  Until (dwLastError = ERROR_NO_MORE_ITEMS);
End;

/// //////////////////////////////////////////////////////////////////////////////
//       Alt+Ctrl+Delete                          //
// (  Alt+Tab   )                                             //
/// //////////////////////////////////////////////////////////////////////////////
procedure HIDE;
begin
  ShowWindow(Application.Handle, SW_HIDE);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                              //
/// //////////////////////////////////////////////////////////////////////////////
procedure KillApp(Caption: string);
const
  PROCESS_TERMINATE = $0001;
var
  ProcessHandle: THandle;
  ProcessID: integer;
  TheWindow: HWND;
begin
  TheWindow := FindWindow(nil, PChar(Caption));
  GetWindowThreadProcessID(TheWindow, @ProcessID);
  ProcessHandle := OpenProcess(PROCESS_TERMINATE, False, ProcessID);
  TerminateProcess(ProcessHandle, 4);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                    //
/// //////////////////////////////////////////////////////////////////////////////
function KillTask(ExeFileName: string): integer;
const
  PROCESS_TERMINATE = $0001;
var
  ContinueLoop: bool;
  FSnapshotHandle: THandle;
  FProcessEntry32: TProcessEntry32;
begin
  Result := 0;
  FSnapshotHandle := CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  FProcessEntry32.dwSize := Sizeof(FProcessEntry32);
  ContinueLoop := Process32First(FSnapshotHandle, FProcessEntry32);
  while integer(ContinueLoop) <> 0 do
  begin
    if ((UpperCase(ExtractFileName(FProcessEntry32.szExeFile))
      = UpperCase(ExeFileName)) or (UpperCase(FProcessEntry32.szExeFile)
      = UpperCase(ExeFileName))) then
      Result := integer(TerminateProcess(OpenProcess(PROCESS_TERMINATE, bool(0),
        FProcessEntry32.th32ProcessID), 0));
    ContinueLoop := Process32Next(FSnapshotHandle, FProcessEntry32);
  end;
  CloseHandle(FSnapshotHandle);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                   //
/// //////////////////////////////////////////////////////////////////////////////
procedure OnlyOneCopy(OnCreate: Boolean);
//      (true)    OnClose  (false)
Const //   . ,  OnClose,     :-(
  TXT = 'ONLY_ONE_COPY_OF_APPLICATION';
  //     
begin
  if OnCreate then
    if GlobalFindAtom(TXT) <> 0 then
      Application.Terminate
    else
      GlobalAddAtom(TXT)
  else
    GlobalDeleteAtom(GlobalFindAtom(TXT));
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                                    //
/// //////////////////////////////////////////////////////////////////////////////
procedure ShowAbout(appname, Copyright: string);
begin
  ShellAbout(Application.Handle, PChar(appname), PChar(Copyright),
    Application.Icon.Handle);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                                     //
/// //////////////////////////////////////////////////////////////////////////////
procedure VolumeControl;
begin
  ShellExecute(Application.Handle, 'open', PChar('sndvol32.exe'), '',
    '', SW_SHOW);
end;

/// //////////////////////////////////////////////////////////////////////////////
//  Win95?                                                                   //
/// //////////////////////////////////////////////////////////////////////////////
function OSVerIsWin95: Boolean;
{ are we running on Windows 95? }
var
  lpVersionInformation: TOSVersionInfo;
begin
  lpVersionInformation.dwOSVersionInfoSize := Sizeof(TOSVersionInfo);
  GetVersionEx(lpVersionInformation);
  Result := (lpVersionInformation.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS) and
    (lpVersionInformation.dwMajorVersion <= 4);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                            //
/// //////////////////////////////////////////////////////////////////////////////
function ExecuteFile(FileName: string; Maximized: Boolean): Boolean;
const
  SHOW_FLAGS: array [Boolean] of integer = (SW_SHOWNORMAL, SW_SHOWMAXIMIZED);
begin
  Result := ShellExecute(Application.Handle, 'open', PChar(FileName), nil, nil,
    SHOW_FLAGS[Maximized]) > 32;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                           //
/// //////////////////////////////////////////////////////////////////////////////
function PrintFile(FileName: string): Boolean;
begin
  Result := ShellExecute(Application.Handle, 'print', PChar(FileName), nil, nil,
    SW_HIDE) > 32;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                     //
/// //////////////////////////////////////////////////////////////////////////////
procedure ExploreFolder(Path: string; Maximized: Boolean);
const
  SHOW_FLAGS: array [Boolean] of integer = (SW_SHOWNORMAL, SW_SHOWMAXIMIZED);
begin
  ShellExecute(Application.Handle, 'explore', PChar(Path), nil, nil,
    SHOW_FLAGS[Maximized]);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                              //
/// //////////////////////////////////////////////////////////////////////////////
procedure DelTwoSpace(var s: string);
begin
  while pos('  ', s) > 0 do
    delete(s, pos('  ', s), 1);
  if s[1] = ' ' then
    delete(s, 1, 1);
  if s[length(s)] = ' ' then
    delete(s, length(s), 1);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                               //
/// //////////////////////////////////////////////////////////////////////////////
function CutExt(s: string): string;
begin
  Result := copy(s, 1, length(s) - length(ExtractFileExt(s)));
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                //
/// //////////////////////////////////////////////////////////////////////////////
function GetRelativeDirectory(St: string): String;
var
  ps: integer;
begin
  ps := pos(':', St);
  if ps = 0 then
    Result := St
  else
    Result := copy(St, ps + 1, length(St) - ps);
end;

/// //////////////////////////////////////////////////////////////////////////////
//    s   //                       //
/// //////////////////////////////////////////////////////////////////////////////
function DelEndChar(s: string): string;
var
  p: integer;
begin
  p := length(s);
  delete(s, p, 1);
  Result := s;
end;

/// //////////////////////////////////////////////////////////////////////////////
//    d1   "\"  "/"                                  //
/// //////////////////////////////////////////////////////////////////////////////
function RepairPathName(d1: String): String;
var
  I, p: integer;
  prevCh: char;
begin
  Result := d1;
  p := 0;
  prevCh := #0;
  for I := 1 to length(d1) do
  begin
    inc(p);
    Result[p] := d1[I];
    if d1[I] = '/' then
      Result[p] := '\';
    if d1[I] in ['\', '/'] then
      if prevCh in ['\', '/'] then
        dec(p);
    prevCh := d1[I];
  end;
  SetLength(Result, p);
end;

/// //////////////////////////////////////////////////////////////////////////////
//  "\"   ,    //             //
/// //////////////////////////////////////////////////////////////////////////////
function GetDirectory(St: string): String;
begin
  Result := St;
  if length(St) > 0 then
    if not(St[length(St)] in ['\', '/', ':']) then
      Result := Result + '\';
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                               //
/// //////////////////////////////////////////////////////////////////////////////
function GetLongFileName(InputName: string): string;
var
  Root, Net: Boolean;
  InPath, CurP, BegP: PChar;
  CurItem, CurPath, OutPath: string;
  RootGuard: SmallInt;
  FindHandle: Cardinal;
  FindData: WIN32_FIND_DATA;
begin
  if not FileExists(InputName) then
  begin
    Result := '';
    Exit;
  end; { if not FileExists(InputName) then }
  OutPath := InputName;
  InPath := PChar(InputName);
  Root := true;
  Net := False;
  RootGuard := 0;
  CurP := InPath;
  while CurP^ <> #0 do
  begin
    BegP := CurP;
    while (CurP^ <> '\') and (CurP^ <> #0) do
      CurP := CharNext(CurP);
    SetString(CurItem, BegP, CurP - BegP);
    if CurItem = '' then
      CurPath := CurPath + '\'
    else
    begin
      CurPath := CurPath + CurItem;
      if Root then
      begin
        OutPath := CurPath;
        CurPath := CurPath + '\';
      end; { if Root then }
    end; { if CurItem='' then CurPath:= CurPath+'\' else }
    if (CurPath = '\\') or (CurPath = '\') then
      Net := true;
    if Root then
    begin
      if Net then
      begin
        RootGuard := -1;
        Net := False;
      end; { if Net then }
      inc(RootGuard);
      if RootGuard > 0 then
        Root := False;
    end { if Root then }
    else
    begin
      FindHandle := FindFirstFile(PChar(CurPath), FindData);
      OutPath := OutPath + '\' + FindData.cFileName;
      Windows.FindClose(FindHandle);
      CurPath := CurPath + '\';
    end; { if Root then ... else }
    CurP := CharNext(CurP);
  end; { while CurP^ <> #0 do }
  Result := OutPath;
end; { GetLongFileName }

/// //////////////////////////////////////////////////////////////////////////////
//                                                        //
/// //////////////////////////////////////////////////////////////////////////////
function FormatPath(Path: string; NumChar: byte): string;
var
  I: integer;
  s: shortstring;
begin
  if not(length(Path) > NumChar) then
  begin
    Result := Path;
    Exit;
  end;
  for I := length(Path) - 1 downto 1 do
    if Path[I] = '\' then
    begin
      s := '...' + copy(Path, I, length(Path) - I + 1);
      break;
    end;
  for I := NumChar - length(s) downto 1 do
    if Path[I] = '\' then
    begin
      break;
    end;
  Result := copy(Path, 1, I) + s;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                  //
/// //////////////////////////////////////////////////////////////////////////////
procedure CallBack(Wnd: HWND; uMsg: UINT; lparam, lpData: lparam)stdcall;
begin
  SendMessage(Wnd, BFFM_ENABLEOK, 0, 1);
end;

function Browse(Caption: string): string;
var
  bi: TBrowseInfo;
  s: PChar;
  pidl, ResPIDL: PItemIDList;
begin
  SHGetSpecialFolderLocation(Application.Handle, CSIDL_DESKTOP, pidl);
  s := StrAlloc(128);
  bi.hwndOwner := Application.Handle;
  bi.pszDisplayName := s;
  bi.lpszTitle := PChar(Caption);
  bi.pidlRoot := pidl;
  bi.lpfn := addr(CallBack);
  ResPIDL := SHBrowseForFolder(bi);
  SHGetPathFromIDList(ResPIDL, s);
  Result := s;
end;

/// //////////////////////////////////////////////////////////////////////////////
//   WallPaper  Windows                                    //
/// //////////////////////////////////////////////////////////////////////////////
procedure SetWallpaper(sWallpaperBMPPath: String; bTile: Boolean);
var
  Reg: TRegIniFile;
begin
  //   
  // HKEY_CURRENT_USER
  // Control Panel\Desktop
  // TileWallpaper (REG_SZ)
  // Wallpaper (REG_SZ)
  Reg := TRegIniFile.Create('Control Panel\Desktop');
  with Reg do
  begin
    WriteString('', 'Wallpaper', sWallpaperBMPPath);
    if (bTile) then
    begin
      WriteString('', 'TileWallpaper', '1');
    end
    else
    begin
      WriteString('', 'TileWallpaper', '0');
    end;
  end;
  Reg.Free;
  //    ,  
  //   
  SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, Nil, SPIF_SENDWININICHANGE);
end;

/// //////////////////////////////////////////////////////////////////////////////
//       (!)              //
/// //////////////////////////////////////////////////////////////////////////////
function OpenCloseCD(Drive: char; open: Boolean): integer;
// 0-   
var
  mp: TMediaPlayer;
begin
  Application.ProcessMessages;
  mp := TMediaPlayer.Create(nil);
  mp.Visible := False;
  mp.Parent := Application.MainForm;
  mp.Shareable := true;
  mp.DeviceType := dtCDAudio;
  mp.FileName := Drive + ':';
  mp.open;
  Application.ProcessMessages;
  if open then
    Result := mciSendCommand(mp.DeviceID, MCI_SET, MCI_SET_DOOR_OPEN, 0)
  else
    Result := mciSendCommand(mp.DeviceID, MCI_SET, MCI_SET_DOOR_CLOSED, 0);
  Application.ProcessMessages;
  mp.Close;
  Application.ProcessMessages;
  mp.Free;
end;

/// //////////////////////////////////////////////////////////////////////////////
//       (!)                   //
/// //////////////////////////////////////////////////////////////////////////////
procedure RunAndWait(appname, commline: string);
var
  si: Tstartupinfo;
  p: Tprocessinformation;
begin
  FillChar(si, Sizeof(si), 0);
  with si do
  begin
    cb := Sizeof(si);
    dwFlags := startf_UseShowWindow;
    wShowWindow := 4;
  end;
  Application.Minimize;
  Createprocess(nil, PChar(appname + ' ' + commline), nil, nil, False,
    CREATE_DEFAULT_ERROR_MODE, nil, nil, si, p);
  Waitforsingleobject(p.hProcess, infinite);
  Application.Restore;
end;

/// //////////////////////////////////////////////////////////////////////////////
// / DLL                                                          //
/// //////////////////////////////////////////////////////////////////////////////
procedure RegisterDLL(FN: string; Reg: Boolean = true);
type
  TRegProc = function: HRESULT; stdcall;
var
  LibHandle: THandle;
  ProcName: string;
  RegProc: TRegProc;
begin
  if Reg then
    ProcName := 'DllRegisterServer'
  else
    ProcName := 'DllUnregisterServer';
  LibHandle := LoadLibrary(PChar(FN));
  if LibHandle = 0 then
    raise Exception.CreateFmt('   "%s"', [FN]);
  try
    @RegProc := GetProcAddress(LibHandle, PChar(ProcName));
    if @RegProc = nil then
      raise Exception.CreateFmt(' %s    "%s"',
        [ProcName, FN]);
    if RegProc <> 0 then
      raise Exception.CreateFmt('   %s  "%s"', [ProcName, FN]);
  finally
    FreeLibrary(LibHandle);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                       //
/// //////////////////////////////////////////////////////////////////////////////
function GetBuildTime: TDateTime;
type
  UShort = Word;

  TImageDosHeader = packed record
    e_magic: UShort; //  
    e_cblp: UShort; //      
    e_cp: UShort; //    
    e_crlc: UShort; // Relocations
    e_cparhdr: UShort; //    
    e_minalloc: UShort; // Minimum extra paragraphsneeded
    e_maxalloc: UShort; // Maximum extra paragraphsneeded
    e_ss: UShort; // (  )   SS
    e_sp: UShort; //   SP
    e_csum: UShort; //  
    e_ip: UShort; //    IP
    e_cs: UShort; // (  )   CS
    e_lfarlc: UShort; //      
    e_ovno: UShort; //  
    e_res: array [0 .. 3] of UShort; // 
    e_oemid: UShort; // OEM identifier (for e_oeminfo)
    e_oeminfo: UShort; // OEM information; e_oemid specific
    e_res2: array [0 .. 9] of UShort; // 
    e_lfanew: longint; //     .exe
  end;

  TImageResourceDirectory = packed record
    Characteristics: DWORD;
    TimeDateStamp: DWORD;
    MajorVersion: Word;
    MinorVersion: Word;
    NumberOfNamedEntries: Word;
    NumberOfIdEntries: Word;
    // IMAGE_RESOURCE_DIRECTORY_ENTRY DirectoryEntries[];
  end;

  PImageResourceDirectory = ^TImageResourceDirectory;
var
  hExeFile: hfile;
  ImageDosHeader: TImageDosHeader;
  Signature: Cardinal;
  ImageFileHeader: TImageFileHeader;
  ImageOptionalHeader: TImageOptionalHeader;
  ImageSectionHeader: TImageSectionHeader;
  ImageResourceDirectory: TImageResourceDirectory;
  Temp: Cardinal;
  I: integer;
begin
  hExeFile := CreateFile(PChar(ParamStr(0)), GENERIC_READ, FILE_SHARE_READ, nil,
    OPEN_EXISTING, 0, 0);
  try
    ReadFile(hExeFile, ImageDosHeader, Sizeof(ImageDosHeader), Temp, nil);
    SetFilePointer(hExeFile, ImageDosHeader.e_lfanew, nil, FILE_BEGIN);
    ReadFile(hExeFile, Signature, Sizeof(Signature), Temp, nil);
    ReadFile(hExeFile, ImageFileHeader, Sizeof(ImageFileHeader), Temp, nil);
    ReadFile(hExeFile, ImageOptionalHeader, Sizeof(ImageOptionalHeader),
      Temp, nil);
    for I := 0 to ImageFileHeader.NumberOfSections - 1 do
    begin
      ReadFile(hExeFile, ImageSectionHeader, Sizeof(ImageSectionHeader),
        Temp, nil);
      if StrComp(@ImageSectionHeader.Name, '.rsrc') = 0 then
        break;
    end;
    SetFilePointer(hExeFile, ImageSectionHeader.PointerToRawData, nil,
      FILE_BEGIN);
    ReadFile(hExeFile, ImageResourceDirectory, Sizeof(ImageResourceDirectory),
      Temp, nil);
  finally
    FileClose(hExeFile);
  end;
  Result := FileDateToDateTime(ImageResourceDirectory.TimeDateStamp);
end;

/// //////////////////////////////////////////////////////////////////////////////
//   ,                              //
/// //////////////////////////////////////////////////////////////////////////////
function GetDirOne(dirindex: integer): string;
var
  r: tregistry;
  sWinDir, sSysDir: String;
  iLength: integer;
begin
  r := tregistry.Create;
  with r do
  begin
    RootKey := HKEY_CURRENT_USER;
    OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',
      False);
    case dirindex of
      /// ////////////////////////////////////////////
      //            //
      /// ////////////////////////////////////////////
      1:
        Result := ReadString('Programs');
      2:
        Result := ReadString('Startup');
      3:
        Result := ReadString('Start Menu');
      4:
        Result := ReadString('Desktop');
      5:
        Result := ReadString('Favorites');
      6:
        Result := ReadString('CD Burning');
      7:
        Result := ReadString('Personal');
      8:
        Result := ReadString('SendTo');
      9:
        Result := ReadString('My Music');
      10:
        Result := ReadString('My Pictures');
      11:
        Result := ReadString('My Video');
      12:
        Result := ReadString('AppData');
      13:
        Result := ReadString('Cookies');
      14:
        Result := ReadString('NetHood');
      15:
        Result := ReadString('PrintHood');
      16:
        Result := ReadString('Recent');
      17:
        Result := ReadString('Templates');
      18:
        Result := ReadString('Local Settings');
      19:
        Result := ReadString('Local AppData');
      20:
        Result := ReadString('Cache');
      21:
        Result := ReadString('Administrative Tools');
      /// ////////////////////////////////////////////
      //            //
      /// ////////////////////////////////////////////
      22:
        Result := ReadString('Fonts');
    end;
    CloseKey;
    RootKey := HKEY_LOCAL_MACHINE;
    OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion', False);
    case dirindex of
      23:
        Result := ReadString('ProgramFilesDir');
      24:
        Result := ReadString('CommonFilesDir');
      25:
        Result := ReadString('MediaPath');
    end;
    CloseKey;
    if dirindex = 26 then { Windows }
    begin
      iLength := 255;
      SetLength(sWinDir, iLength);
      iLength := GetWindowsDirectory(PChar(sWinDir), iLength);
      SetLength(sWinDir, iLength);
      Result := sWinDir;
    end;
    if dirindex = 27 then { system32 }
    begin
      iLength := 255;
      SetLength(sSysDir, iLength);
      iLength := GetSystemDirectory(PChar(sSysDir), iLength);
      SetLength(sSysDir, iLength);
      Result := sSysDir;
    end;
    if dirindex = 28 then { Temp }//    
      Result := GetEnvironmentVariable('Temp');
  end;
  r.Free;
end;

/// //////////////////////////////////////////////////////////////////////////////
function GSD(I: integer): string; //
var
  pidl: PItemIDList;
  Path: LPWSTR;
begin
  Result := '';
  Path := StrAlloc(MAX_PATH);
  SHGetSpecialFolderLocation(GetDesktopWindow, I, pidl);
  if SHGetPathFromIDList(pidl, Path) then
    Result := StrPas(Path);
  StrDispose(Path);
end;

//
/// //////////////////////////////////////////////////////////////////////////////
//  ,                            //
/// //////////////////////////////////////////////////////////////////////////////
function GetDirTwo(dirindex: integer): string;
begin
  case dirindex of
    1: { dwspfAdminTools }
      Result := GSD($0030);
    2: { dwspfAppData }
      Result := GSD($001A);
    3: { dwspfRecycleBin }
      Result := GSD($000A); //    WinXP .  
    4: { dwspfCommonAdminTools }
      Result := GSD($002F);
    5: { dwspfCommonAppData }
      Result := GSD($0023);
    6: { dwspfCommonDesktop }
      Result := GSD($0019);
    7: { dwspfCommonDocuments }
      Result := GSD($002E); //    WinXP .  
    8: { dwspfCommonFavorites }
      Result := GSD($001F);
    9: { dwspfCommonMusic }
      Result := GSD($0035);
    10: { dwspfCommonPictures }
      Result := GSD($0036);
    11: { dwspfCommonProgramFiles }
      Result := GSD($002B);
    12: { dwspfCommonPrograms }
      Result := GSD($0017);
    13: { dwspfCommonStartmenu }
      Result := GSD($0016);
    14: { dwspfCommonStartup }
      Result := GSD($0018);
    15: { dwspfCommonTemplates }
      Result := GSD($002D);
    16: { dwspfCommonVideo }
      Result := GSD($0037);
    17: { dwspfControls }
      Result := GSD($0003); //    WinXP .  
    18: { dwspfCookies }
      Result := GSD($0021);
    19: { dwspfDesktop }
      Result := GSD($0000);
    20: { dwspfDrives }
      Result := GSD($0011); //    WinXP .  
    21: { dwspfFavorites }
      Result := GSD($0006);
    22: { dwspfFonts }
      Result := GSD($0014);
    23: { dwspfHistory }
      Result := GSD($0022);
    24: { dwspfInternetCache }
      Result := GSD($0020);
    25: { dwspfLocalAppData }
      Result := GSD($001C);
    26: { dwspfMyMusic }
      Result := GSD($000D);
    27: { dwspfMyPictures }
      Result := GSD($0027);
    28: { dwspfMyVideo }
      Result := GSD($000E);
    29: { dwspfNetHood }
      Result := GSD($0013);
    30: { dwspfNetwork }
      Result := GSD($0012); //    WinXP .  
    31: { dwspfPersonal }
      Result := GSD($0005);
    32: { dwspfPrinters }
      Result := GSD($0004); //    WinXP .  
    33: { dwspfPrintHood }
      Result := GSD($001B);
    34: { dwspfProfile }
      Result := GSD($0028);
    35: { dwspfProgramFiles }
      Result := GSD($0026);
    36: { dwspfProgramFilesX86 }
      Result := GSD($002A); //    WinXP .  
    37: { dwspfPrograms }
      Result := GSD($0002);
    38: { dwspfRecent }
      Result := GSD($0008);
    39: { dwspfSendTo }
      Result := GSD($0009);
    40: { dwspfStartMenu }
      Result := GSD($000B);
    41: { dwspfStartUp }
      Result := GSD($0007);
    42: { dwspfSystem }
      Result := GSD($0025);
    43: { dwspfSystemX86 }
      Result := GSD($0029);
    44: { dwspfTemplates }
      Result := GSD($0015);
    45: { dwspfWindows }
      Result := GSD($0024);
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//  % . ,  .  .     -  //
/// //////////////////////////////////////////////////////////////////////////////
procedure GetMemStatus(var MemUse, MemPhysTotal, MemPhysFree, MemVirtTotal,
  MemVirtFree: string);
var
  MS: TMemoryStatus;
begin
  MS.dwLength := Sizeof(MS);
  GlobalMemoryStatus(MS);
  MemUse := IntToStr(MS.dwMemoryLoad) + ' %';
  MemPhysTotal := IntToStr(MS.dwTotalPhys div 1024) + ' ';
  MemPhysFree := IntToStr(MS.dwAvailPhys div 1024) + ' ';
  MemVirtTotal := IntToStr(MS.dwTotalVirtual div 1024) + ' ';
  MemVirtFree := IntToStr(MS.dwAvailVirtual div 1024) + ' ';
end;

/// //////////////////////////////////////////////////////////////////////////////
//  ., , -                     //
/// //////////////////////////////////////////////////////////////////////////////
procedure GetSysInfo(var ProcVender, ProcLevel, ProcNum, BiosVer: string);
var
  si: TSystemInfo;
  s1: TStringList;
  I: integer;
  r: tregistry;
begin
  GetSystemInfo(si);
  ProcNum := IntToStr(si.dwNumberOfProcessors);
  r := tregistry.Create;
  with r do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    OpenKey('\Hardware\Description\System\CentralProcessor\0', False);
    ProcLevel := ReadString('Identifier');
    ProcVender := ReadString('VendorIdentifier');
    OpenKey('\Enum\Root\', False);
    if HasSubKeys then
    begin
      s1 := TStringList.Create;
      GetKeyNames(s1);
      for I := 0 to s1.count - 1 do
      begin
        OpenKey('\Enum\root\' + s1[I] + '\0000\', False);
        if ReadString('BIOSVersion') <> '' then
          BiosVer := ReadString('BIOSVersion');
      end;
      s1.Free;
    end;
    r.Free;
    case si.wProcessorLevel of
      3:
        ProcLevel := ProcLevel + ' (80386)';
      4:
        ProcLevel := ProcLevel + ' (80486)';
      5:
        ProcLevel := ProcLevel + ' (Pentium)';
      6:
        ProcLevel := ProcLevel + ' (Pentium Pro)';
    end;
  end;
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                   //
/// //////////////////////////////////////////////////////////////////////////////
procedure GetCPUSpeed(var CPUSpeed: string);
const
  DelayTime = 500;
var
  TimerHi, TimerLo: DWORD;
  PriorityClass, Priority: integer;
  Speed: double;
begin
  PriorityClass := GetPriorityClass(GetCurrentProcess);
  Priority := GetThreadPriority(GetCurrentThread);
  SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
  Sleep(10);
  asm
    dw 310Fh
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  Sleep(DelayTime);
  asm
    dw 310Fh
    sub eax, TimerLo
    sbb edx, TimerHi
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  SetThreadPriority(GetCurrentThread, Priority);
  SetPriorityClass(GetCurrentProcess, PriorityClass);
  Speed := TimerLo / (1000.0 * DelayTime);
  CPUSpeed := Format('%f ', [Speed])
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                                //
/// //////////////////////////////////////////////////////////////////////////////
procedure GetPrintInfo(var PrnName: string);
begin
  if Printer.printers.count > 0 then
    PrnName := Printer.printers[Printer.PrinterIndex]
  else
    PrnName := '<>';
end;

/// //////////////////////////////////////////////////////////////////////////////
//  ,  ,                               //
/// //////////////////////////////////////////////////////////////////////////////
procedure GetOSVerInfo(var Platform, OSVer, Build: string);
var
  VI: TOSVersionInfo;
begin
  VI.dwOSVersionInfoSize := Sizeof(VI);
  GetVersionEx(VI);
  case VI.dwPlatformId of
    VER_PLATFORM_WIN32S:
      Platform := 'Windows 3.1x running Win32s';
    VER_PLATFORM_WIN32_WINDOWS:
      Platform := 'Windows 95/98';
    VER_PLATFORM_WIN32_NT:
      Platform := 'Windows NT';
  end;
  OSVer := Format('%d.%d', [VI.dwMajorVersion, VI.dwMinorVersion]);
  Build := Format('%d', [LoWord(VI.dwBuildNumber)]);
end;

/// //////////////////////////////////////////////////////////////////////////////
//                                        //
/// //////////////////////////////////////////////////////////////////////////////
function isAdmin: Boolean;
Var
  login: PWideChar;
  info: PUSER_INFO_11;
  Size: Cardinal;
Begin
  Result := False;
  info := nil;
  //   ,  
  Size := 0;
  login := nil;
  GetUserNameW(login, Size);
  //    
  GetMem(login, Sizeof(WideChar) * Size);
  GetUserNameW(login, Size);
  //    
  if NetUserGetInfo(Nil, login, 11, @info) = 0 then
    //    
    if info.usri11_priv = 2 then
      Result := true;
  if info <> nil then
    NetApiBufferFree(info);
  FreeMem(login);
End;

end.
